# File I/O in Java (Binary Streams)

## 1. What the Code Does

This program demonstrates how to **copy a binary file** in Java:

- It opens an image file (`wissam-fawaz.jpg`) using a `FileInputStream`.
- It creates a target file (`copy.jpg`) using a `FileOutputStream`.
- It reads chunks of bytes from the source into a buffer.
- It writes these bytes to the target file until the entire file is copied.
- Finally, it closes both streams.

This is a typical approach when handling images, videos, or any non-text data.

---

## 2. Exception Handling

Currently, the program declares `throws IOException` in the `main` method signature.  
This means any file-related error (e.g., missing file, permission issues) will stop the program and print a stack trace.

As an extension, you can use a **try-catch block** to handle errors more gracefully.

---

## 3. Java Streams

Java uses **streams** to process data sequentially:

- **Byte-based streams** (`InputStream`, `OutputStream`): Used for raw binary data such as images, audio, and video.
- **Character-based streams** (`Reader`, `Writer`): Used for text data, with automatic handling of character encoding.

In this program, we use **byte-based streams** (`FileInputStream`, `FileOutputStream`) since we are copying an image file, not text.

---

## 4. Possible Extension: Using Try-Catch

By surrounding the I/O code with a `try-catch`, we can provide user-friendly error messages:

```java
public static void main(String[] args) {
    try {
        File srcFile = new File("src/com/wissamfawaz/wissam-fawaz.jpg");
        File trgtFile = new File("src/com/wissamfawaz/copy.jpg");

        FileInputStream fis = new FileInputStream(srcFile);
        FileOutputStream fos = new FileOutputStream(trgtFile);

        byte[] buf = new byte[1024];
        int len;

        while ((len = fis.read(buf)) > 0) {
            fos.write(buf, 0, len);
        }

        fis.close();
        fos.close();
    } catch (IOException e) {
        System.out.println("An error occurred while copying the file: " + e.getMessage());
    }
}
```
